//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.1
import QtGraphicalEffects 1.0

import wesual.Controls 1.0

FocusScope {
    id : colorBox

    property var colors : []
    property int maxPopUpWidth : 200
    property int currentIndex : -1

    readonly property bool open : popup.popupVisible
    readonly property var currentColor : {
        if (currentIndex >= 0 && currentIndex < colors.length) {
            return colors[currentIndex];
        }
        return colors[0];
    }

    function openPopup()  {
        popup.activeIndex = currentIndex;
        popup.show();
    }
    Keys.onUpPressed : {
        if (colors.length < 1 || currentIndex === 0)
            return;

        currentIndex--;
    }
    Keys.onDownPressed : {
        if (currentIndex < (colors.length - 1))
            currentIndex++;
    }

    width : 44 // selected color width + indicator(20)
    implicitHeight : 26

    Rectangle {
        id : background

        width : parent.width
        height : 26
        color : UI.color(UI.PrimaryBase)
        border {
            width : 1
            color : (mouseArea.containsMouse || colorBox.activeFocus) ?
                   UI.color(UI.PrimaryHover) : UI.color(UI.PrimaryControlBorder)
        }

        Behavior on border.color {
            ColorAnimation { duration : 0 }
        }

        Rectangle {
            id : selectionColor
            color : currentColor
            width : 22
            height : 22
            anchors {
                top : parent.top
                topMargin : 2
                left : parent.left
                leftMargin : 2
            }

            Behavior on color {
                ColorAnimation { duration : 0 }
            }
        }

        Item {
            id : indicatorContainer
            width : 20
            height : 22
            anchors.right : parent.right

            Image {
                id : indicator
                anchors {
                    horizontalCenter : parent.horizontalCenter
                    verticalCenter : parent.verticalCenter
                    verticalCenterOffset : 2
                }
                source : "qrc:/controls/images/dropdown-indicator.png"
                visible : false
            }

            ColorOverlay {
                source : indicator
                anchors.fill : indicator
                color : (mouseArea.containsMouse || colorBox.popupVisible
                           || colorBox.activeFocus) ?
                            UI.color(UI.PrimaryHover) : "#000"

                Behavior on color {
                    ColorAnimation { duration : 0 }
                }
            }
        } // indicator wrapper
    } // container

    MouseArea {
        id : mouseArea

        hoverEnabled : true
        anchors.fill : parent
        acceptedButtons : Qt.LeftButton
        onPressed : colorBox.open ? popup.hide() : colorBox.openPopup()
    }

    ColorBoxPopup {
        id : popup
        items : colorBox.colors
        colorBox : colorBox

        onAccepted : {
            colorBox.currentIndex = result;
            popup.hide();
        }
    }
}
